library(mediation)

p_m_y_10_99 <- matrix(nrow=100,ncol=12)
colnames(p_m_y_10_99) <- c("R10","R13.7","R15","R20","R30","R40","R50","R60","R70","R80","R90","R99")
p_prop_10_99 <- matrix(nrow=100,ncol=12)
colnames(p_prop_10_99) <- c("R10","R13.7","R15","R20","R30","R40","R50","R60","R70","R80","R90","R99")
p_acme_10_99 <- matrix(nrow=100,ncol=12)
colnames(p_acme_10_99) <- c("R10","R13.7","R15","R20","R30","R40","R50","R60","R70","R80","R90","R99")

R2_10_99 <- c(10,13.7,15,20,30,40,50,60,70,80,90,99)
for (j in 1:12) {
	n=2440
	beta=0.022764 *3.44
	R2=R2_10_99[j] #~13.7% variation in m can be explained by BMI

	for (i in 1:100){
		BMI=rnorm(n)
		m=BMI+rnorm(n)*sqrt(100/R2-1) 
		p=exp(beta*BMI-0.5)/(1+exp(beta*BMI-0.5))
		y=rbinom(n,1,prob=p)
		table(y)
		b=BMI>0

		p_m_y_10_99[i,j] <- summary(glm(y~b+m,family=binomial(link="logit")))$coeff[3,4]

		model.m <- lm(m ~ b)
		model.y <- glm(y ~ b + m, family=binomial(link="logit"))
		s_m <- mediate(model.m, model.y, sims=1000, treat="b", mediator="m")
		p_prop_10_99[i,j] <- s_m$n1.p
		p_acme_10_99[i,j] <- s_m$d1.p
	}
}

p_m_y_10_99 <- as.data.frame(p_m_y_10_99)
par(mfrow=c(3,4))
hist(p_m_y_10_99$R10,col="red",main="R2=0.10")
hist(p_m_y_10_99$R13.7,col="red",main="R2=0.137")
hist(p_m_y_10_99$R15,col="red",main="R2=0.15")
hist(p_m_y_10_99$R20,col="red",main="R2=0.20")
hist(p_m_y_10_99$R30,col="red",main="R2=0.30")
hist(p_m_y_10_99$R40,col="red",main="R2=0.40")
hist(p_m_y_10_99$R50,col="red",main="R2=0.50")
hist(p_m_y_10_99$R60,col="red",main="R2=0.60")
hist(p_m_y_10_99$R70,col="red",main="R2=0.70")
hist(p_m_y_10_99$R80,col="red",main="R2=0.80")
hist(p_m_y_10_99$R90,col="red",main="R2=0.90")
hist(p_m_y_10_99$R99,col="red",main="R2=0.99")

p_acme_10_99 <- as.data.frame(p_acme_10_99)
par(mfrow=c(3,4))
hist(p_acme_10_99$R10,col="red",main="R2=0.10")
hist(p_acme_10_99$R13.7,col="red",main="R2=0.137")
hist(p_acme_10_99$R15,col="red",main="R2=0.15")
hist(p_acme_10_99$R20,col="red",main="R2=0.20")
hist(p_acme_10_99$R30,col="red",main="R2=0.30")
hist(p_acme_10_99$R40,col="red",main="R2=0.40")
hist(p_acme_10_99$R50,col="red",main="R2=0.50")
hist(p_acme_10_99$R60,col="red",main="R2=0.60")
hist(p_acme_10_99$R70,col="red",main="R2=0.70")
hist(p_acme_10_99$R80,col="red",main="R2=0.80")
hist(p_acme_10_99$R90,col="red",main="R2=0.90")
hist(p_acme_10_99$R99,col="red",main="R2=0.99")

min_p=vector()
min_p_med=vector()
for (i in 1:12){
	min_p[i]<-min(p_m_y_10_99[,i])
	min_p_med[i]<-min(p_acme_10_99[,i])
}